<?php
include 'constants.php';
spl_autoload_register('classLoader');
session_start();

try{
  $portal = new PortalFront("localhost", "php", "test", "ksiegarnia");
  
  $action = 'showMain';
  if (isset($_GET['action'])) {
    $action = $_GET['action'];
  }
  
  $komunikat = $portal->getMessage();
  if(!$komunikat && $action == 'showLoginForm'){
    $komunikat = 'Wprowad nazw i haso uytkownika';
  }
  
  switch($action){
    case 'login' : 
      //Obsuga logowania
      break;
    case 'logout': 
      //Obsuga wylogowania
      break;
    case 'registerUser':
      //Obsuga rejestracji uytkownika
      break;
    case 'addToBasket':
      //Dodawanie ksiki do koszyka
      break;
    case 'modifyBasket':
      //Modyfikacja zawartoci koszyka
      break;
    case 'saveOrder':
      //Zapis zamwienia w bazie danych
      break;
    default:
      include 'templates/mainTemplate.php';
  }
}
catch(Exception $e){
  //echo 'Bd: ' . $e->getMessage();
  exit('Portal chwilowo niedostpny');
}

function classLoader($nazwa){
  if(file_exists("klasy/$nazwa.php")){
    require_once("klasy/$nazwa.php");
  } else {
    throw new Exception("Brak pliku z definicj klasy.");
  }
}
?>
